import sys
import os
sys.path.append(os.path.dirname(os.path.dirname(os.path.abspath(__file__))))
from utils.main import main, parse_args
from copy import deepcopy


def run_exp(base_args):
    temp = deepcopy(sys.argv)
    sys.argv = deepcopy(base_args)
    a = parse_args()
    try:
        log = main(a)
    except Exception as e:
        print('An exception occurred: {}'.format(e))
    sys.argv = temp


if __name__ == '__main__':
    datasets = ['seq-tinyimg', 'seq-cifar10', 'seq-cifar100', 'hetro-cifar100', 'hetro-tinyimg']
    for dataset in datasets:
        run_exp(sys.argv + ['--dataset', dataset])
